/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.config;

import java.util.ArrayList;
import java.util.regex.Pattern;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.ConfigTools;

public class ConfigUtils {
    public static void normalizeServerConfig(boolean saveAfter) {
        ConfigUtils.normalizeServerConfig();
        if (saveAfter) {
            ConfigTools.save(GlobalVariables.serverConfigFile, GlobalVariables.serverConfig);
        }
    }

    public static void normalizeServerConfig() {
        String fixed;
        String trimmed;
        ArrayList<String> fixedSyncedFiles = new ArrayList<String>(GlobalVariables.serverConfig.syncedFiles.size());
        ArrayList<String> fixedAllowEditsInFiles = new ArrayList<String>(GlobalVariables.serverConfig.allowEditsInFiles.size());
        ArrayList<String> fixedForceCopyFilesToStandardLocation = new ArrayList<String>(GlobalVariables.serverConfig.forceCopyFilesToStandardLocation.size());
        String prefixPattern = "^/automodpack/host-modpack/[^/]+/";
        Pattern pattern = Pattern.compile(prefixPattern);
        for (String file : GlobalVariables.serverConfig.syncedFiles) {
            if (file == null) {
                GlobalVariables.LOGGER.warn("Ignored null entry in syncedFiles.");
                continue;
            }
            trimmed = file.trim();
            if (trimmed.isEmpty()) {
                GlobalVariables.LOGGER.warn("Ignored empty entry in syncedFiles.");
                continue;
            }
            if (pattern.matcher(trimmed).find()) {
                GlobalVariables.LOGGER.info("Removed redundant syncedFiles entry '{}': paths under '/automodpack/host-modpack/' are implicitly synced.", (Object)file);
                continue;
            }
            fixedSyncedFiles.add(ConfigUtils.prefixSlash(file));
        }
        for (String file : GlobalVariables.serverConfig.allowEditsInFiles) {
            if (file == null) {
                GlobalVariables.LOGGER.warn("Ignored null entry in allowEditsInFiles.");
                continue;
            }
            trimmed = file.trim();
            if (trimmed.isEmpty()) {
                GlobalVariables.LOGGER.warn("Ignored empty entry in allowEditsInFiles.");
                continue;
            }
            fixed = pattern.matcher(trimmed).replaceFirst("");
            if (!fixed.equals(trimmed)) {
                GlobalVariables.LOGGER.info("Normalized allowEditsInFiles entry: '{}' -> '{}'. Removed '/automodpack/host-modpack/' prefix.", (Object)file, (Object)fixed);
            }
            fixedAllowEditsInFiles.add(ConfigUtils.prefixSlash(fixed));
        }
        for (String file : GlobalVariables.serverConfig.forceCopyFilesToStandardLocation) {
            if (file == null) {
                GlobalVariables.LOGGER.warn("Ignored null entry in forceCopyFilesToStandardLocation.");
                continue;
            }
            trimmed = file.trim();
            if (trimmed.isEmpty()) {
                GlobalVariables.LOGGER.warn("Ignored empty entry in forceCopyFilesToStandardLocation.");
                continue;
            }
            fixed = pattern.matcher(trimmed).replaceFirst("");
            if (!fixed.equals(trimmed)) {
                GlobalVariables.LOGGER.info("Normalized forceCopyFilesToStandardLocation entry: '{}' -> '{}'. Removed '/automodpack/host-modpack/' prefix.", (Object)file, (Object)fixed);
            }
            fixedForceCopyFilesToStandardLocation.add(ConfigUtils.prefixSlash(fixed));
        }
        GlobalVariables.serverConfig.syncedFiles = fixedSyncedFiles;
        GlobalVariables.serverConfig.allowEditsInFiles = fixedAllowEditsInFiles;
        GlobalVariables.serverConfig.forceCopyFilesToStandardLocation = fixedForceCopyFilesToStandardLocation;
    }

    public static String prefixSlash(String path) {
        if (path == null) {
            return null;
        }
        if (path.isEmpty()) {
            return path;
        }
        if (path.startsWith("/!/")) {
            return path.substring(1);
        }
        if (path.startsWith("/")) {
            return path;
        }
        if (path.startsWith("!/")) {
            return path;
        }
        if (path.charAt(0) == '!') {
            return "!/" + path.substring(1);
        }
        return "/" + path;
    }
}

