/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.utils.LockFreeInputStream;

public class CustomFileUtils {
    private static final byte[] smallDummyJar = new byte[]{80, 75, 3, 4, 20, 0, 8, 8, 8, 0, 89, 116, -44, 86, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 0, 4, 0, 77, 69, 84, 65, 45, 73, 78, 70, 47, 77, 65, 78, 73, 70, 69, 83, 84, 46, 77, 70, -2, -54, 0, 0, -13, 77, -52, -53, 76, 75, 45, 46, -47, 13, 75, 45, 42, -50, -52, -49, -77, 82, 48, -44, 51, -32, -27, -30, -27, 2, 0, 80, 75, 7, 8, -78, 127, 2, -18, 27, 0, 0, 0, 25, 0, 0, 0, 80, 75, 1, 2, 20, 0, 20, 0, 8, 8, 8, 0, 89, 116, -44, 86, -78, 127, 2, -18, 27, 0, 0, 0, 25, 0, 0, 0, 20, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 77, 69, 84, 65, 45, 73, 78, 70, 47, 77, 65, 78, 73, 70, 69, 83, 84, 46, 77, 70, -2, -54, 0, 0, 80, 75, 5, 6, 0, 0, 0, 0, 1, 0, 1, 0, 70, 0, 0, 0, 97, 0, 0, 0, 0, 0};
    private static final Path CWD = Path.of(System.getProperty("user.dir"), new String[0]);

    public static void executeOrder66(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (Files.isRegularFile(file, new LinkOption[0])) {
            CustomFileUtils.dummyIT(file);
        }
    }

    public static Path getPathFromCWD(String path) {
        return CustomFileUtils.getPath(CWD, path);
    }

    public static Path getPath(Path origin, String path) {
        if (origin == null) {
            throw new IllegalArgumentException("Origin path must not be null");
        }
        if (path == null || path.isBlank()) {
            return origin;
        }
        if ((path = path.replace('\\', '/')).startsWith("/")) {
            path = path.substring(1);
        }
        return origin.resolve(path).normalize();
    }

    public static boolean isFilePhysical(Path path) {
        return path.getFileSystem() == FileSystems.getDefault();
    }

    public static void copyFile(Path source, Path destination) throws IOException {
        CustomFileUtils.setupFilePaths(destination);
        try (LockFreeInputStream is = new LockFreeInputStream(source);
             OutputStream os = Files.newOutputStream(destination, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            is.transferTo(os);
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.error("Failed to copy a file from {} to {}", (Object)source, (Object)destination);
        }
    }

    public static void setupFilePaths(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            if (!Files.exists(file.getParent(), new LinkOption[0])) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            file.toFile().createNewFile();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean compareFilesByteByByte(Path path, byte[] referenceBytes) {
        try {
            if (Files.size(path) != (long)referenceBytes.length) {
                return false;
            }
            try (BufferedInputStream is = new BufferedInputStream(new LockFreeInputStream(path));){
                int b;
                int i = 0;
                while ((b = ((InputStream)is).read()) != -1) {
                    if (b == (referenceBytes[i++] & 0xFF)) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Error comparing file byte by byte: {}", (Object)path, (Object)e);
            return false;
        }
    }

    public static String formatPath(Path modpackFile, Path modpackPath) {
        if (modpackPath == null || modpackFile == null) {
            throw new IllegalArgumentException("Arguments are null - modpackPath: " + String.valueOf(modpackPath) + ", modpackFile: " + String.valueOf(modpackFile));
        }
        String modpackFileStr = modpackFile.normalize().toString();
        String modpackFileStrAbs = modpackFile.toAbsolutePath().normalize().toString();
        String modpackPathStrAbs = modpackPath.toAbsolutePath().normalize().toString();
        String cwdStrAbs = Path.of(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize().toString();
        String formattedFile = modpackFileStr;
        if (modpackFileStrAbs.startsWith(modpackPathStrAbs)) {
            formattedFile = modpackFileStrAbs.substring(modpackPathStrAbs.length());
        } else if (modpackFileStrAbs.startsWith(cwdStrAbs)) {
            formattedFile = modpackFileStrAbs.substring(cwdStrAbs.length());
        } else if (!modpackFileStrAbs.equals(modpackFileStr)) {
            GlobalVariables.LOGGER.error("File: {} ({}) is not in modpack directory: {} ({}) or current working directory: {}", (Object)modpackFileStr, (Object)modpackFileStrAbs, (Object)modpackPath, (Object)modpackPathStrAbs, (Object)cwdStrAbs);
        }
        formattedFile = formattedFile.replace(File.separator, "/");
        formattedFile = CustomFileUtils.prefixSlash(formattedFile);
        return formattedFile;
    }

    public static String prefixSlash(String path) {
        if (!path.isEmpty() && path.charAt(0) == '/') {
            return path;
        }
        return "/" + path;
    }

    public static void deleteDummyFiles(Path directory, Set<Jsons.ModpackContentFields.ModpackContentItem> ignoreList) {
        if (directory == null || ignoreList == null) {
            return;
        }
        try (Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);){
            stream.filter(path -> !CustomFileUtils.shouldIgnore(path, ignoreList)).forEach(path -> {
                if (CustomFileUtils.compareFilesByteByByte(path, smallDummyJar)) {
                    CustomFileUtils.executeOrder66(path);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean shouldIgnore(Path file, Set<Jsons.ModpackContentFields.ModpackContentItem> ignoreList) {
        if (ignoreList == null) {
            return false;
        }
        String modpackFile = CustomFileUtils.formatPath(file, Objects.requireNonNullElse(GlobalVariables.selectedModpackDir, GlobalVariables.hostContentModpackDir));
        for (Jsons.ModpackContentFields.ModpackContentItem item : ignoreList) {
            if (!item.file.equals(modpackFile)) continue;
            return true;
        }
        return false;
    }

    public static void dummyIT(Path file) {
        try (FileOutputStream fos = new FileOutputStream(file.toFile());){
            fos.write(smallDummyJar);
            fos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getHash(Path path) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            try (BufferedInputStream is = new BufferedInputStream(new LockFreeInputStream(path));
                 DigestInputStream dis = new DigestInputStream(is, digest);){
                dis.transferTo(OutputStream.nullOutputStream());
            }
            byte[] hash = digest.digest();
            return HexFormat.of().formatHex(hash);
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Failed to get hash for path: {}", (Object)path, (Object)e);
            return null;
        }
    }

    public static String getCurseforgeMurmurHash(Path file) throws IOException {
        byte[] filteredBytes;
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        long length = 0L;
        ByteArrayOutputStream filteredStream = new ByteArrayOutputStream();
        try (BufferedInputStream is = new BufferedInputStream(new LockFreeInputStream(file));){
            int b;
            while ((b = ((InputStream)is).read()) != -1) {
                if (b == 9 || b == 10 || b == 13 || b == 32) continue;
                filteredStream.write(b);
                ++length;
            }
        }
        int m = 1540483477;
        int r = 24;
        long k = 0L;
        int seed = 1;
        int shift = 0;
        long h = (long)seed ^ length;
        for (byte byteVal : filteredBytes = filteredStream.toByteArray()) {
            char b = (char)(byteVal & 0xFF);
            k |= (long)b << shift;
            if ((shift += 8) != 32) continue;
            h = 0xFFFFFFFFL & h;
            k *= 1540483477L;
            k = 0xFFFFFFFFL & k;
            k ^= k >> 24;
            k = 0xFFFFFFFFL & k;
            k *= 1540483477L;
            k = 0xFFFFFFFFL & k;
            h *= 1540483477L;
            h = 0xFFFFFFFFL & h;
            h ^= k;
            h = 0xFFFFFFFFL & h;
            k = 0L;
            shift = 0;
        }
        if (shift > 0) {
            h ^= k;
            h = 0xFFFFFFFFL & h;
            h *= 1540483477L;
            h = 0xFFFFFFFFL & h;
        }
        h ^= h >> 13;
        h = 0xFFFFFFFFL & h;
        h *= 1540483477L;
        h = 0xFFFFFFFFL & h;
        h ^= h >> 15;
        h = 0xFFFFFFFFL & h;
        return String.valueOf(h);
    }

    public static boolean hashCompare(Path file1, Path file2) {
        if (!Files.exists(file1, new LinkOption[0]) || !Files.exists(file2, new LinkOption[0])) {
            return false;
        }
        String hash1 = CustomFileUtils.getHash(file1);
        String hash2 = CustomFileUtils.getHash(file2);
        if (hash1 == null || hash2 == null) {
            return false;
        }
        return hash1.equals(hash2);
    }

    public static boolean isEmptyDirectory(Path parentPath) throws IOException {
        if (!Files.isDirectory(parentPath, new LinkOption[0])) {
            return false;
        }
        try (Stream<Path> pathStream = Files.list(parentPath);){
            boolean bl = pathStream.findAny().isEmpty();
            return bl;
        }
    }
}

