/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.auth.Secrets;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.protocol.DownloadClient;
import pl.skidam.automodpack_core.protocol.NetUtils;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_core.utils.FileInspection;
import pl.skidam.automodpack_core.utils.ModpackContentTools;
import pl.skidam.automodpack_loader_core.screen.ScreenManager;

public class ModpackUtils {
    public static boolean isUpdate(Jsons.ModpackContentFields serverModpackContent, Path modpackDir) {
        Set existingFileTree;
        if (serverModpackContent == null || serverModpackContent.list == null) {
            throw new IllegalArgumentException("Server modpack content list is null");
        }
        Optional<Path> optionalClientModpackContentFile = ModpackContentTools.getModpackContentFile(modpackDir);
        if (optionalClientModpackContentFile.isEmpty() || !Files.exists(optionalClientModpackContentFile.get(), new LinkOption[0])) {
            return true;
        }
        Jsons.ModpackContentFields clientModpackContent = ConfigTools.loadModpackContent(optionalClientModpackContentFile.get());
        if (clientModpackContent == null) {
            return true;
        }
        GlobalVariables.LOGGER.info("Indexing file system...");
        long start = System.currentTimeMillis();
        try (Stream<Path> stream = Files.walk(modpackDir, new FileVisitOption[0]);){
            existingFileTree = stream.collect(Collectors.toSet());
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.error("Failed to walk directory", (Throwable)e);
            return true;
        }
        GlobalVariables.LOGGER.info("Verifying content against server list...");
        boolean hasMismatches = serverModpackContent.list.parallelStream().anyMatch(modpackContentField -> {
            Path path = CustomFileUtils.getPath(modpackDir, modpackContentField.file);
            if (!existingFileTree.contains(path)) {
                GlobalVariables.LOGGER.info("Missing file: {}", (Object)modpackContentField.file);
                return true;
            }
            if (modpackContentField.editable) {
                return false;
            }
            String diskHash = CustomFileUtils.getHash(path);
            if (!Objects.equals(modpackContentField.sha1, diskHash)) {
                GlobalVariables.LOGGER.info("Hash mismatch: {}", (Object)modpackContentField.file);
                return true;
            }
            return false;
        });
        if (hasMismatches) {
            return true;
        }
        Set serverFileSet = serverModpackContent.list.stream().map(item -> item.file).collect(Collectors.toSet());
        GlobalVariables.LOGGER.info("Checking for deleted files...");
        for (Jsons.ModpackContentFields.ModpackContentItem clientItem : clientModpackContent.list) {
            if (serverFileSet.contains(clientItem.file)) continue;
            GlobalVariables.LOGGER.info("File marked for deletion (not on server): {}", (Object)clientItem.file);
            return true;
        }
        long end = System.currentTimeMillis();
        GlobalVariables.LOGGER.info("{} is up to date! Took {} ms", (Object)modpackDir, (Object)(end - start));
        return false;
    }

    public static boolean correctFilesLocations(Path modpackDir, Jsons.ModpackContentFields serverModpackContent, Set<String> filesNotToCopy) throws IOException {
        boolean needsRestart = false;
        for (Jsons.ModpackContentFields.ModpackContentItem contentItem : serverModpackContent.list) {
            String formattedFile = contentItem.file;
            Path modpackFile = CustomFileUtils.getPath(modpackDir, formattedFile);
            Path runFile = CustomFileUtils.getPathFromCWD(formattedFile);
            boolean isMod = "mod".equals(contentItem.type);
            if (isMod) {
                runFile = CustomFileUtils.getPath(GlobalVariables.MODS_DIR, formattedFile.replaceFirst("/mods/", ""));
            }
            boolean modpackFileExists = Files.exists(modpackFile, new LinkOption[0]);
            boolean runFileExists = Files.exists(runFile, new LinkOption[0]);
            boolean runFileHashMatch = false;
            if (runFileExists) {
                runFileHashMatch = Objects.equals(contentItem.sha1, CustomFileUtils.getHash(runFile));
            }
            if (runFileHashMatch && !modpackFileExists) {
                GlobalVariables.LOGGER.debug("Copying {} file to the modpack directory", (Object)formattedFile);
                CustomFileUtils.copyFile(runFile, modpackFile);
                modpackFileExists = true;
            }
            if (filesNotToCopy.contains(formattedFile)) continue;
            if (modpackFileExists && !runFileExists) {
                CustomFileUtils.copyFile(modpackFile, runFile);
                if (!isMod) continue;
                needsRestart = true;
                GlobalVariables.LOGGER.warn("Applying workaround for {} mod", (Object)formattedFile);
                continue;
            }
            if (!modpackFileExists) {
                GlobalVariables.LOGGER.error("File {} doesn't exist!? If you see this please report this to the automodpack repo and attach this log https://github.com/Skidamek/AutoModpack/issues", (Object)formattedFile);
                Thread.dumpStack();
                continue;
            }
            if (runFileHashMatch) continue;
            CustomFileUtils.copyFile(modpackFile, runFile);
            if (isMod) {
                needsRestart = true;
                GlobalVariables.LOGGER.warn("Overwriting mod {} file to modpack version", (Object)formattedFile);
                continue;
            }
            GlobalVariables.LOGGER.info("Overwriting {} file to the modpack version", (Object)formattedFile);
        }
        return needsRestart;
    }

    public static boolean removeRestModsNotToCopy(Jsons.ModpackContentFields serverModpackContent, Set<String> filesNotToCopy, Set<Path> modsToKeep) {
        boolean needsRestart = false;
        for (Jsons.ModpackContentFields.ModpackContentItem contentItem : serverModpackContent.list) {
            String formattedFile = contentItem.file;
            Path runFile = CustomFileUtils.getPathFromCWD(formattedFile);
            boolean isMod = "mod".equals(contentItem.type);
            if (isMod) {
                runFile = CustomFileUtils.getPath(GlobalVariables.MODS_DIR, formattedFile.replaceFirst("/mods/", ""));
            }
            if (modsToKeep.contains(runFile)) {
                GlobalVariables.LOGGER.info("Keeping {} file in the standard mods directory", (Object)formattedFile);
                continue;
            }
            boolean runFileExists = Files.exists(runFile, new LinkOption[0]);
            boolean runFileHashMatch = false;
            if (runFileExists) {
                runFileHashMatch = Objects.equals(contentItem.sha1, CustomFileUtils.getHash(runFile));
            }
            if (!runFileHashMatch || !isMod || !filesNotToCopy.contains(formattedFile)) continue;
            GlobalVariables.LOGGER.info("Deleting {} file from standard mods directory", (Object)formattedFile);
            CustomFileUtils.executeOrder66(runFile);
            needsRestart = true;
        }
        return needsRestart;
    }

    public static boolean fixNestedMods(List<FileInspection.Mod> conflictingNestedMods, Collection<FileInspection.Mod> standardModList) throws IOException {
        if (conflictingNestedMods.isEmpty()) {
            return false;
        }
        List<String> standardModIDs = standardModList.stream().map(FileInspection.Mod::modID).toList();
        boolean needsRestart = false;
        for (FileInspection.Mod mod : conflictingNestedMods) {
            Path modPath;
            Path standardModPath;
            if (standardModIDs.stream().anyMatch(mod.providesIDs()::contains) || Files.exists(standardModPath = GlobalVariables.MODS_DIR.resolve((modPath = mod.modPath()).getFileName()), new LinkOption[0]) && Objects.equals(CustomFileUtils.getHash(standardModPath), mod.hash())) continue;
            needsRestart = true;
            GlobalVariables.LOGGER.info("Copying nested mod {} to standard mods folder", (Object)standardModPath.getFileName());
            CustomFileUtils.copyFile(modPath, standardModPath);
            FileInspection.Mod newMod = FileInspection.getMod(standardModPath);
            if (newMod == null) continue;
            standardModList.add(newMod);
        }
        return needsRestart;
    }

    public static Set<String> getIgnoredFiles(List<FileInspection.Mod> conflictingNestedMods, Set<String> workarounds) {
        HashSet<String> newIgnoredFiles = new HashSet<String>(workarounds);
        for (FileInspection.Mod mod : conflictingNestedMods) {
            newIgnoredFiles.add(CustomFileUtils.formatPath(mod.modPath(), GlobalVariables.modpacksDir));
        }
        return newIgnoredFiles;
    }

    public static Map<FileInspection.Mod, FileInspection.Mod> getDupeMods(Path modpackDir, Set<String> ignoredMods, Collection<FileInspection.Mod> standardModList, Collection<FileInspection.Mod> modpackModList, Set<String> forceCopyFiles) {
        HashMap<FileInspection.Mod, FileInspection.Mod> duplicates = new HashMap<FileInspection.Mod, FileInspection.Mod>();
        for (FileInspection.Mod modpackMod : modpackModList) {
            String formattedFile;
            FileInspection.Mod standardMod = standardModList.stream().filter(mod -> mod.modID().equals(modpackMod.modID())).findFirst().orElse(null);
            if (standardMod == null || ignoredMods.contains(formattedFile = CustomFileUtils.formatPath(modpackMod.modPath(), modpackDir)) || forceCopyFiles.contains(formattedFile)) continue;
            duplicates.put(modpackMod, standardMod);
        }
        return duplicates;
    }

    public static RemoveDupeModsResult removeDupeMods(Path modpackDir, Collection<FileInspection.Mod> standardModList, Collection<FileInspection.Mod> modpackModList, Set<String> ignoredMods, Set<String> workaroundMods, Set<String> forceCopyFiles) throws IOException {
        Map<FileInspection.Mod, FileInspection.Mod> dupeMods = ModpackUtils.getDupeMods(modpackDir, ignoredMods, standardModList, modpackModList, forceCopyFiles);
        if (dupeMods.isEmpty()) {
            return new RemoveDupeModsResult(false, Set.of());
        }
        HashSet<FileInspection.Mod> modsToKeep = new HashSet<FileInspection.Mod>();
        for (FileInspection.Mod standardMod : standardModList) {
            if (dupeMods.containsValue(standardMod)) continue;
            modsToKeep.add(standardMod);
            ModpackUtils.addDependenciesRecursively(standardMod, standardModList, modsToKeep);
        }
        HashSet idsToKeep = new HashSet();
        modsToKeep.forEach(mod -> {
            idsToKeep.add(mod.modID());
            idsToKeep.addAll(mod.providesIDs());
        });
        boolean requiresRestart = false;
        HashSet<Path> dependentMods = new HashSet<Path>();
        for (Map.Entry<FileInspection.Mod, FileInspection.Mod> dupeMod : dupeMods.entrySet()) {
            FileInspection.Mod modpackMod = dupeMod.getKey();
            FileInspection.Mod standardMod = dupeMod.getValue();
            Path modpackModPath = modpackMod.modPath();
            Path standardModPath = standardMod.modPath();
            String modId = modpackMod.modID();
            String formatedPath = CustomFileUtils.formatPath(standardModPath, GlobalVariables.MODS_DIR.getParent());
            Collection<String> providesIDs = modpackMod.providesIDs();
            ArrayList<String> IDs = new ArrayList<String>(providesIDs);
            IDs.add(modId);
            boolean isDependent = IDs.stream().anyMatch(idsToKeep::contains);
            boolean isWorkaround = workaroundMods.contains(formatedPath);
            boolean isForceCopy = forceCopyFiles.contains(formatedPath);
            if (isDependent) {
                Path newStandardModPath = standardModPath.getParent().resolve(modpackModPath.getFileName());
                dependentMods.add(newStandardModPath);
                if (Objects.equals(modpackMod.hash(), standardMod.hash())) continue;
                GlobalVariables.LOGGER.warn("Changing duplicated mod {} - {} to modpack version - {}", (Object)modId, (Object)standardMod.modVersion(), (Object)modpackMod.modVersion());
                CustomFileUtils.executeOrder66(standardModPath);
                CustomFileUtils.copyFile(modpackModPath, newStandardModPath);
                requiresRestart = true;
                continue;
            }
            if (isWorkaround || isForceCopy) continue;
            GlobalVariables.LOGGER.warn("Removing {} mod. It is duplicated modpack mod and no other mods are dependent on it!", (Object)modId);
            CustomFileUtils.executeOrder66(standardModPath);
            requiresRestart = true;
        }
        return new RemoveDupeModsResult(requiresRestart, dependentMods);
    }

    private static void addDependenciesRecursively(FileInspection.Mod mod, Collection<FileInspection.Mod> modList, Set<FileInspection.Mod> modsToKeep) {
        for (String depId : mod.dependencies()) {
            for (FileInspection.Mod modItem : modList) {
                if (!modItem.modID().equals(depId) && !modItem.providesIDs().contains(depId) || !modsToKeep.add(modItem)) continue;
                ModpackUtils.addDependenciesRecursively(modItem, modList, modsToKeep);
            }
        }
    }

    public static Path renameModpackDir(Jsons.ModpackContentFields serverModpackContent, Path modpackDir) {
        if (GlobalVariables.clientConfig.installedModpacks == null || GlobalVariables.clientConfig.selectedModpack == null || GlobalVariables.clientConfig.selectedModpack.isBlank()) {
            return modpackDir;
        }
        String installedModpackName = GlobalVariables.clientConfig.selectedModpack;
        Jsons.ModpackAddresses installedModpackAddresses = GlobalVariables.clientConfig.installedModpacks.get(installedModpackName);
        String serverModpackName = serverModpackContent.modpackName;
        if (installedModpackAddresses != null && !serverModpackName.equals(installedModpackName) && !serverModpackName.isEmpty()) {
            Path newModpackDir = modpackDir.getParent().resolve(serverModpackName);
            try {
                Files.move(modpackDir, newModpackDir, StandardCopyOption.REPLACE_EXISTING);
                ModpackUtils.removeModpackFromList(installedModpackName);
                GlobalVariables.LOGGER.info("Changed modpack name of {} to {}", (Object)modpackDir.getFileName().toString(), (Object)serverModpackName);
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ModpackUtils.selectModpack(newModpackDir, installedModpackAddresses, Set.of());
            return newModpackDir;
        }
        return modpackDir;
    }

    public static boolean selectModpack(Path modpackDirToSelect, Jsons.ModpackAddresses modpackAddresses, Set<String> newDownloadedFiles) {
        String oldName;
        String newName = modpackDirToSelect.getFileName().toString();
        if (Objects.equals(newName, oldName = GlobalVariables.clientConfig.selectedModpack)) {
            ModpackUtils.addModpackToList(newName, modpackAddresses);
            return false;
        }
        GlobalVariables.LOGGER.info("Preserving editable files from old modpack and copying to new modpack...");
        if (oldName != null && !oldName.isBlank()) {
            ModpackUtils.processEditableFiles(GlobalVariables.modpacksDir.resolve(oldName), (dir, files) -> ModpackUtils.preserveEditableFiles(dir, files, newDownloadedFiles));
        }
        ModpackUtils.processEditableFiles(modpackDirToSelect, (dir, files) -> ModpackUtils.copyPreviousEditableFiles(dir, files, newDownloadedFiles));
        GlobalVariables.clientConfig.selectedModpack = newName;
        ConfigTools.save(GlobalVariables.clientConfigFile, GlobalVariables.clientConfig);
        ModpackUtils.addModpackToList(newName, modpackAddresses);
        GlobalVariables.LOGGER.info("Selected modpack: {}", (Object)newName);
        return true;
    }

    private static void processEditableFiles(Path modpackDir, BiConsumer<Path, Set<String>> action) {
        Path contentFile = modpackDir.resolve(GlobalVariables.hostModpackContentFile.getFileName());
        Jsons.ModpackContentFields content = ConfigTools.loadModpackContent(contentFile);
        if (content != null) {
            Set<String> editableFiles = ModpackUtils.getEditableFiles(content.list);
            action.accept(modpackDir, editableFiles);
        }
    }

    public static void removeModpackFromList(String modpackName) {
        if (modpackName == null || modpackName.isEmpty()) {
            return;
        }
        if (GlobalVariables.clientConfig.installedModpacks != null && GlobalVariables.clientConfig.installedModpacks.containsKey(modpackName)) {
            HashMap<String, Jsons.ModpackAddresses> modpacks = new HashMap<String, Jsons.ModpackAddresses>(GlobalVariables.clientConfig.installedModpacks);
            modpacks.remove(modpackName);
            GlobalVariables.clientConfig.installedModpacks = modpacks;
            ConfigTools.save(GlobalVariables.clientConfigFile, GlobalVariables.clientConfig);
        }
    }

    public static void addModpackToList(String modpackName, Jsons.ModpackAddresses modpackAddresses) {
        if (modpackName == null || modpackName.isEmpty() || modpackAddresses.isAnyEmpty()) {
            return;
        }
        HashMap<String, Jsons.ModpackAddresses> modpacks = new HashMap<String, Jsons.ModpackAddresses>(GlobalVariables.clientConfig.installedModpacks);
        modpacks.put(modpackName, modpackAddresses);
        GlobalVariables.clientConfig.installedModpacks = modpacks;
        ConfigTools.save(GlobalVariables.clientConfigFile, GlobalVariables.clientConfig);
    }

    public static Path getModpackPath(InetSocketAddress address, String modpackName) {
        String strAddress = address.getHostString() + ":" + address.getPort();
        Object correctedName = strAddress;
        if (FileInspection.isInValidFileName(strAddress)) {
            correctedName = FileInspection.fixFileName(strAddress);
        }
        Path modpackDir = CustomFileUtils.getPath(GlobalVariables.modpacksDir, (String)correctedName);
        if (!modpackName.isEmpty()) {
            String nameFromName = modpackName;
            if (FileInspection.isInValidFileName(modpackName)) {
                nameFromName = FileInspection.fixFileName(modpackName);
            }
            modpackDir = CustomFileUtils.getPath(GlobalVariables.modpacksDir, nameFromName);
        }
        return modpackDir;
    }

    public static Optional<Jsons.ModpackContentFields> requestServerModpackContent(Jsons.ModpackAddresses modpackAddresses, Secrets.Secret secret, boolean allowAskingUser) {
        return ModpackUtils.fetchModpackContent(modpackAddresses, secret, client -> client.downloadFile(new byte[0], GlobalVariables.modpackContentTempFile, null), "Fetched", allowAskingUser);
    }

    public static Optional<Jsons.ModpackContentFields> refreshServerModpackContent(Jsons.ModpackAddresses modpackAddresses, Secrets.Secret secret, byte[][] fileHashes, boolean allowAskingUser) {
        return ModpackUtils.fetchModpackContent(modpackAddresses, secret, client -> client.requestRefresh(fileHashes, GlobalVariables.modpackContentTempFile), "Re-fetched", allowAskingUser);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<Jsons.ModpackContentFields> fetchModpackContent(Jsons.ModpackAddresses modpackAddresses, Secrets.Secret secret, Function<DownloadClient, Future<Path>> operation, String fetchType, boolean allowAskingUser) {
        if (secret == null) {
            return Optional.empty();
        }
        if (modpackAddresses.isAnyEmpty()) {
            throw new IllegalArgumentException("Modpack addresses are empty!");
        }
        try (DownloadClient client = DownloadClient.tryCreate(modpackAddresses, secret.secretBytes(), 1, ModpackUtils.userValidationCallback(modpackAddresses.hostAddress, allowAskingUser));){
            if (client == null) {
                Optional<Jsons.ModpackContentFields> optional = Optional.empty();
                return optional;
            }
            Future<Path> future = operation.apply(client);
            Path path = future.get();
            Optional<Jsons.ModpackContentFields> content = Optional.ofNullable(ConfigTools.loadModpackContent(path));
            Files.deleteIfExists(GlobalVariables.modpackContentTempFile);
            if (content.isPresent() && ModpackUtils.potentiallyMalicious(content.get())) {
                Optional<Jsons.ModpackContentFields> optional = Optional.empty();
                return optional;
            }
            Optional<Jsons.ModpackContentFields> optional = content;
            return optional;
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Error while getting server modpack content", (Throwable)e);
            return Optional.empty();
        }
    }

    public static boolean canConnectModpackHost(Jsons.ModpackAddresses modpackAddresses) {
        if (modpackAddresses.isAnyEmpty()) {
            throw new IllegalArgumentException("Modpack addresses are empty!");
        }
        DownloadClient client = DownloadClient.tryCreate(modpackAddresses, null, 1, null);
        try {
            boolean bl;
            boolean bl2 = bl = client != null;
            if (client != null) {
                client.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                GlobalVariables.LOGGER.error("Error while pinging AutoModpack host server", (Throwable)e);
                return false;
            }
        }
    }

    public static Function<X509Certificate, Boolean> userValidationCallback(InetSocketAddress address, boolean allowAskingUser) {
        return certificate -> {
            String fingerprint;
            try {
                fingerprint = NetUtils.getFingerprint(certificate);
            }
            catch (CertificateEncodingException e) {
                return false;
            }
            if (Objects.equals(GlobalVariables.knownHosts.hosts.get(address.getHostString()), fingerprint)) {
                return true;
            }
            GlobalVariables.LOGGER.warn("Received untrusted certificate from server {}!", (Object)address.getHostString());
            if (allowAskingUser) {
                boolean trusted = ModpackUtils.askUserAboutCertificate(address, fingerprint);
                if (trusted) {
                    GlobalVariables.knownHosts.hosts.put(address.getHostString(), fingerprint);
                    ConfigTools.save(GlobalVariables.knownHostsFile, GlobalVariables.knownHosts);
                }
                return trusted;
            }
            return false;
        };
    }

    private static Boolean askUserAboutCertificate(InetSocketAddress address, String fingerprint) {
        GlobalVariables.LOGGER.info("Asking user for {}", (Object)address.getHostString());
        Optional<Object> screen = new ScreenManager().getScreen();
        if (screen.isEmpty()) {
            GlobalVariables.LOGGER.warn("No screen available, cannot ask user");
            return false;
        }
        CountDownLatch latch = new CountDownLatch(1);
        AtomicBoolean accepted = new AtomicBoolean(false);
        Runnable trustCallback = () -> {
            accepted.set(true);
            latch.countDown();
        };
        Runnable cancelCallback = latch::countDown;
        new ScreenManager().validation(screen.get(), fingerprint, trustCallback, cancelCallback);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            return false;
        }
        return accepted.get();
    }

    public static boolean potentiallyMalicious(Jsons.ModpackContentFields serverModpackContent) {
        if (ModpackUtils.isUnsafePath(serverModpackContent.modpackName, true)) {
            GlobalVariables.LOGGER.error("Modpack content is invalid: modpack name '{}' is unsafe/malicious", (Object)serverModpackContent.modpackName);
            return true;
        }
        if (serverModpackContent.list == null || serverModpackContent.list.isEmpty()) {
            return false;
        }
        return serverModpackContent.list.parallelStream().anyMatch(item -> {
            if (ModpackUtils.isUnsafePath(item.file, false)) {
                GlobalVariables.LOGGER.error("Modpack content is invalid: file path '{}' is unsafe/malicious", (Object)item.file);
                return true;
            }
            return false;
        });
    }

    private static boolean isUnsafePath(String rawPath, boolean blankIsFine) {
        String[] segments;
        if (rawPath == null) {
            return true;
        }
        if (!blankIsFine && rawPath.isBlank()) {
            return true;
        }
        if (rawPath.indexOf(0) != -1) {
            return true;
        }
        if (!rawPath.contains("..")) {
            return false;
        }
        String normalized = rawPath.replace('\\', '/');
        if (normalized.equals("..") || normalized.equals(".")) {
            return true;
        }
        for (String segment : segments = normalized.split("/")) {
            if (!segment.equals("..")) continue;
            return true;
        }
        return false;
    }

    public static void preserveEditableFiles(Path modpackDir, Set<String> editableFiles, Set<String> newDownloadedFiles) {
        for (String file : editableFiles) {
            Path path;
            if (newDownloadedFiles.contains(file) || !Files.exists(path = CustomFileUtils.getPathFromCWD(file), new LinkOption[0])) continue;
            try {
                CustomFileUtils.copyFile(path, CustomFileUtils.getPath(modpackDir, file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyPreviousEditableFiles(Path modpackDir, Set<String> editableFiles, Set<String> newDownloadedFiles) {
        for (String file : editableFiles) {
            Path path;
            if (newDownloadedFiles.contains(file) || file.contains("/mods/") && file.endsWith(".jar") || !Files.exists(path = CustomFileUtils.getPath(modpackDir, file), new LinkOption[0])) continue;
            try {
                CustomFileUtils.copyFile(path, CustomFileUtils.getPathFromCWD(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static Set<String> getEditableFiles(Set<Jsons.ModpackContentFields.ModpackContentItem> modpackContentItems) {
        HashSet<String> editableFiles = new HashSet<String>();
        for (Jsons.ModpackContentFields.ModpackContentItem modpackContentItem : modpackContentItems) {
            if (!modpackContentItem.editable) continue;
            editableFiles.add(modpackContentItem.file);
        }
        return editableFiles;
    }

    public record RemoveDupeModsResult(boolean requiresRestart, Set<Path> modsToKeep) {
    }
}

