/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core_16.mods;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.LanguageAdapter;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.ModContainerImpl;
import net.fabricmc.loader.impl.discovery.DirectoryModCandidateFinder;
import net.fabricmc.loader.impl.discovery.ModCandidateImpl;
import net.fabricmc.loader.impl.discovery.ModDiscoverer;
import net.fabricmc.loader.impl.discovery.ModResolutionException;
import net.fabricmc.loader.impl.discovery.ModResolver;
import net.fabricmc.loader.impl.discovery.RuntimeModRemapper;
import net.fabricmc.loader.impl.gui.FabricGuiEntry;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.metadata.DependencyOverrides;
import net.fabricmc.loader.impl.metadata.VersionOverrides;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.loader.LoaderManagerService;
import pl.skidam.automodpack_core.loader.ModpackLoaderService;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_core.utils.FileInspection;
import pl.skidam.automodpack_loader_core.FabricLanguageAdapter;
import pl.skidam.automodpack_loader_core.FabricLoaderImplAccessor;
import pl.skidam.automodpack_loader_core_16.mods.ModContainerModCandidateFinder;

public class ModpackLoader16
implements ModpackLoaderService {
    private final Map<String, Set<ModCandidateImpl>> envDisabledMods = new HashMap<String, Set<ModCandidateImpl>>();

    @Override
    public void loadModpack(List<Path> modpackMods) {
        Path modpackModsDir = null;
        Iterator<Path> iterator = modpackMods.iterator();
        if (iterator.hasNext()) {
            Path path = iterator.next();
            modpackModsDir = path.toAbsolutePath().normalize().getParent();
        }
        if (modpackModsDir == null) {
            return;
        }
        try {
            GlobalVariables.LOGGER.info("Discovering mods from {}", (Object)(String.valueOf(modpackModsDir.getParent().getFileName()) + "/" + String.valueOf(modpackModsDir.getFileName())));
            List candidates = (List)this.discoverMods(modpackModsDir);
            candidates = (List)this.resolveMods(candidates);
            FabricLoaderImplAccessor.METHOD_DUMP_MOD_LIST.invoke((Object)FabricLoaderImpl.INSTANCE, candidates);
            this.addMods(candidates);
            this.setupLanguageAdapters(candidates);
        }
        catch (Exception e) {
            FabricGuiEntry.displayCriticalError((Throwable)e, (boolean)true);
        }
    }

    @Override
    public List<FileInspection.Mod> getModpackNestedConflicts(Path modpackDir) {
        Path modpackModsDir = modpackDir.resolve("mods");
        Path standardModsDir = GlobalVariables.MODS_DIR;
        List<ModCandidateImpl> modpackNestedMods = new ArrayList<ModCandidateImpl>();
        List<ModCandidateImpl> standardNestedMods = new ArrayList<ModCandidateImpl>();
        try {
            List candidates = (List)this.discoverMods(modpackModsDir);
            candidates.forEach(it -> this.applyPaths((ModCandidateImpl)it, false));
            for (ModCandidateImpl modCandidateImpl : candidates) {
                boolean isStandard;
                if (!modCandidateImpl.isRoot()) continue;
                List<ModCandidateImpl> list2 = this.getNestedMods(modCandidateImpl);
                list2 = this.getOnlyNewestMods(list2);
                boolean bl = isStandard = !((Path)modCandidateImpl.getPaths().get(0)).toAbsolutePath().toString().contains(modpackModsDir.toAbsolutePath().toString());
                if (isStandard) {
                    standardNestedMods.addAll(list2);
                    continue;
                }
                modpackNestedMods.addAll(list2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        modpackNestedMods = this.getOnlyNewestMods(modpackNestedMods);
        standardNestedMods = this.getOnlyNewestMods(standardNestedMods);
        List<ModCandidateImpl> conflictingNestedModsImpl = new ArrayList<ModCandidateImpl>();
        for (ModCandidateImpl modCandidateImpl : standardNestedMods) {
            for (ModCandidateImpl modpackNestedMod : modpackNestedMods) {
                if (!modCandidateImpl.getId().equals(modpackNestedMod.getId()) || modpackNestedMod.getVersion().compareTo((Object)modCandidateImpl.getVersion()) <= 0) continue;
                conflictingNestedModsImpl.add(modpackNestedMod);
            }
        }
        conflictingNestedModsImpl = this.getOnlyNewestMods(conflictingNestedModsImpl);
        ArrayList<ModCandidateImpl> modsNestedDeps = new ArrayList<ModCandidateImpl>();
        for (ModCandidateImpl modCandidateImpl : conflictingNestedModsImpl) {
            List<ModCandidateImpl> nestedDeps = this.getNestedDeps(modCandidateImpl);
            for (ModCandidateImpl nestedDep : nestedDeps) {
                if (conflictingNestedModsImpl.stream().anyMatch(it -> it.getId().equals(nestedDep.getId())) || modsNestedDeps.stream().anyMatch(it -> it.getId().equals(nestedDep.getId()))) continue;
                modsNestedDeps.add(nestedDep);
            }
        }
        conflictingNestedModsImpl.addAll(modsNestedDeps);
        ArrayList arrayList = new ArrayList();
        for (ModCandidateImpl mod : conflictingNestedModsImpl) {
            mod.getParentMods().stream().filter(ModCandidateImpl::isRoot).findFirst().map(ModCandidateImpl::getId).ifPresent(arrayList::add);
        }
        ArrayList<FileInspection.Mod> arrayList2 = new ArrayList<FileInspection.Mod>();
        for (ModCandidateImpl mod : conflictingNestedModsImpl) {
            String hash;
            Path path;
            if (arrayList.stream().anyMatch(mod.getProvides()::contains) || (path = (Path)mod.getPaths().get(0)) == null || path.toString().isEmpty() || !Files.exists(path, new LinkOption[0]) || (hash = CustomFileUtils.getHash(path)) == null) continue;
            FileInspection.Mod conflictingMod = new FileInspection.Mod(mod.getId(), hash, mod.getProvides(), mod.getVersion().getFriendlyString(), path, LoaderManagerService.EnvironmentType.UNIVERSAL, mod.getDependencies().stream().map(ModDependency::getModId).toList());
            arrayList2.add(conflictingMod);
        }
        return arrayList2;
    }

    private List<ModCandidateImpl> getNestedMods(ModCandidateImpl originMod) {
        ArrayList<ModCandidateImpl> mods = new ArrayList<ModCandidateImpl>();
        for (ModCandidateImpl nested : originMod.getNestedMods()) {
            mods.add(nested);
            mods.addAll(this.getNestedMods(nested));
        }
        return mods;
    }

    private List<ModCandidateImpl> getNestedDeps(ModCandidateImpl nestedMod) {
        ArrayList<ModCandidateImpl> deps = new ArrayList<ModCandidateImpl>();
        ModCandidateImpl originMod = !nestedMod.isRoot() ? (ModCandidateImpl)nestedMod.getParentMods().stream().toList().get(0) : nestedMod;
        for (ModDependency dep : nestedMod.getDependencies()) {
            ModCandidateImpl candidate = originMod.getNestedMods().stream().filter(it -> it.getId().equals(dep.getModId())).findFirst().orElse(null);
            if (candidate == null) continue;
            deps.add(candidate);
        }
        return deps;
    }

    private List<ModCandidateImpl> getOnlyNewestMods(List<ModCandidateImpl> allMods) {
        ArrayList<ModCandidateImpl> latestMods = new ArrayList<ModCandidateImpl>();
        for (ModCandidateImpl standardNestedMod : allMods) {
            boolean alreadyExists = latestMods.stream().anyMatch(existingMod -> {
                boolean hasSameId = existingMod.getId().equals(standardNestedMod.getId());
                boolean hasGreaterOrEqualVersion = existingMod.getVersion().compareTo((Object)standardNestedMod.getVersion()) >= 0;
                return hasSameId && hasGreaterOrEqualVersion;
            });
            if (alreadyExists) continue;
            latestMods.removeIf(existingMod -> existingMod.getId().equals(standardNestedMod.getId()));
            latestMods.add(standardNestedMod);
        }
        return latestMods;
    }

    private Collection<ModCandidateImpl> discoverMods(Path modpackModsDir) throws ModResolutionException, IllegalAccessException {
        ModDiscoverer discoverer = new ModDiscoverer(new VersionOverrides(), new DependencyOverrides(FabricLoaderImpl.INSTANCE.getConfigDir()));
        List<DirectoryModCandidateFinder> candidateFinders = List.of(new ModContainerModCandidateFinder(FabricLanguageAdapter.getAllMods().stream().toList()), new DirectoryModCandidateFinder(modpackModsDir, FabricLoaderImpl.INSTANCE.isDevelopmentEnvironment()));
        FabricLoaderImplAccessor.FIELD_CANDIDATE_FINDERS.set(discoverer, candidateFinders);
        return discoverer.discoverMods(FabricLoaderImpl.INSTANCE, this.envDisabledMods);
    }

    private Collection<ModCandidateImpl> resolveMods(Collection<ModCandidateImpl> modCandidates) throws ModResolutionException {
        HashSet<String> modIds = new HashSet<String>();
        for (ModContainer mod : FabricLanguageAdapter.getAllMods().stream().toList()) {
            ModContainerImpl container = (ModContainerImpl)mod;
            modIds.add(container.getMetadata().getId());
        }
        List candidates = ModResolver.resolve(modCandidates, (EnvType)FabricLoaderImpl.INSTANCE.getEnvironmentType(), this.envDisabledMods);
        candidates.removeIf(it -> modIds.contains(it.getId()));
        candidates.forEach(it -> this.applyPaths((ModCandidateImpl)it, true));
        return candidates;
    }

    private void addMods(Collection<ModCandidateImpl> candidates) {
        try {
            for (ModCandidateImpl candidate : candidates) {
                this.addMod(candidate);
            }
        }
        catch (Exception e) {
            FabricGuiEntry.displayCriticalError((Throwable)e, (boolean)true);
        }
    }

    public void addMod(ModCandidateImpl candidate) throws IllegalAccessException {
        ModContainerImpl container = new ModContainerImpl(candidate);
        FabricLanguageAdapter.addMod(container);
        Map modMap = (Map)FabricLoaderImplAccessor.FIELD_MOD_MAP.get(FabricLoaderImpl.INSTANCE);
        modMap.put(candidate.getId(), container);
        for (String provides : candidate.getProvides()) {
            modMap.put(provides, container);
        }
        FabricLoaderImplAccessor.FIELD_MOD_MAP.set(FabricLoaderImpl.INSTANCE, modMap);
        if (!candidate.hasPath() && !candidate.isBuiltin()) {
            this.applyPaths(candidate, true);
        }
        for (Path it : candidate.getPaths()) {
            FabricLauncherBase.getLauncher().addToClassPath(it, new String[0]);
        }
    }

    private void applyPaths(ModCandidateImpl candidate, boolean remap) {
        try {
            Path cacheDir = FabricLoaderImpl.INSTANCE.getGameDir().resolve(".fabric");
            Path processedModsDir = cacheDir.resolve("processedMods");
            if (remap && FabricLoaderImpl.INSTANCE.isDevelopmentEnvironment() && System.getProperty("fabric.remapClasspathFile") != null) {
                RuntimeModRemapper.remap(Collections.singleton(candidate), (Path)cacheDir.resolve("tmp"), (Path)processedModsDir);
            }
            if (!candidate.hasPath() && !candidate.isBuiltin()) {
                candidate.setPaths(Collections.singletonList(candidate.copyToDir(processedModsDir, false)));
            }
        }
        catch (Exception e) {
            FabricGuiEntry.displayCriticalError((Throwable)e, (boolean)true);
        }
    }

    private void setupLanguageAdapters(Collection<ModCandidateImpl> candidates) throws IllegalAccessException {
        Map adapterMap = (Map)FabricLoaderImplAccessor.FIELD_ADAPTER_MAP.get(FabricLoaderImpl.INSTANCE);
        for (ModCandidateImpl candidate : candidates) {
            Map definitions = candidate.getMetadata().getLanguageAdapterDefinitions();
            if (definitions.isEmpty()) continue;
            GlobalVariables.LOGGER.info("Setting up language adapter for {}", (Object)candidate.getId());
            for (Map.Entry entry : definitions.entrySet()) {
                if (!candidate.getId().equals("automodpack") && adapterMap.containsKey(entry.getKey())) {
                    FabricGuiEntry.displayCriticalError((Throwable)new IllegalArgumentException("Duplicate language adapter ID: " + (String)entry.getKey()), (boolean)true);
                }
                try {
                    Class<?> adapterClass = Class.forName((String)entry.getValue(), true, FabricLauncherBase.getLauncher().getTargetClassLoader());
                    LanguageAdapter adapter = (LanguageAdapter)adapterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    adapterMap.put((String)entry.getKey(), adapter);
                }
                catch (Exception e) {
                    FabricGuiEntry.displayCriticalError((Throwable)new RuntimeException("Error setting up language adapter for " + (String)entry.getKey(), e), (boolean)true);
                }
            }
        }
    }
}

