#include "/lib/all_the_libs.glsl"

varying vec2 texcoord;
varying float DepthCenterL;
varying float DepthCenter;

/* DRAWBUFFERS:06 */
const bool colortex0MipmapEnabled = true;

float calc_CoC(float Depth, float DepthCenter) {
    float focalLength = DepthCenter / (DepthCenter + 1);

    float CoC = abs(DOF_APERTURE_SIZE * (focalLength * (Depth - DepthCenter)) /
          (Depth * (DepthCenter - focalLength)));
    return CoC;
}

const vec2 vogel_disk[32] = vec2[](
	vec2(0.12064426510477419, 0.015554431411765695),
	vec2(-0.16400077998918963, 0.16180237012184204),
	vec2(0.020080498035937415, -0.2628838391620438),
	vec2(0.19686650437195816, 0.27801320993574674),
	vec2(-0.37362329188851157, -0.049763799980476156),
	vec2(0.34544673107582735, -0.20696126421568928),
	vec2(-0.12135781397691386, 0.4507963336805642),
	vec2(-0.22749138875333694, -0.41407969197383454),
	vec2(0.4797593802468298, 0.19235249500691445),
	vec2(-0.5079968434096749, 0.22345015963708734),
	vec2(0.23843255951864029, -0.5032700515259672),
	vec2(0.17505863904522073, 0.587555727235086),
	vec2(-0.5451127409909945, -0.2978253068585009),
	vec2(0.6300137885218894, -0.12390992876509886),
	vec2(-0.391501580064061, 0.5662295575692019),
	vec2(-0.09379538975841809, -0.6746452122696498),
	vec2(0.5447160222309757, 0.47831268960533435),
	vec2(-0.7432342062047558, 0.046109375942755174),
	vec2(0.5345993903170301, -0.520777903066999),
	vec2(-0.0404139208253129, 0.7953459466435174),
	vec2(-0.517173266802963, -0.5989723613060595),
	vec2(0.8080038585189984, 0.12485626574164435),
	vec2(-0.6926663754026566, 0.494463047083117),
	vec2(0.183730322451809, -0.8205069509230769),
	vec2(0.43067753069940745, 0.7747454863024757),
	vec2(-0.8548041452377114, -0.25576180722119723),
	vec2(0.8217466662308877, -0.3661258311820314),
	vec2(-0.36224393661662146, 0.87070999332353),
	vec2(-0.32376306917956177, -0.8724793262829371),
	vec2(0.8455529005007657, 0.4622425905108438),
	vec2(-0.9483903811252437, 0.2643989345002705),
	vec2(0.5322400733549763, -0.818975339518135)
);

vec3 blur_dof(vec2 texcoord, float CoC) {
    vec3 Sum = vec3(0);
	CoC *= gbufferProjection[1][1] / 1.37; // Scale according to fov
	vec2 Radius = resolutionInv * CoC;

    for(int i = 0; i < DOF_BLUR_QUALITY; i++) {
        vec2 Offset = vogel_disk[i] * Radius;
		float lod = log2(CoC * 0.5);
        Sum += texture2DLod(colortex0, texcoord + Offset, lod).rgb;
    }

    return Sum / DOF_BLUR_QUALITY;
}

void main() {
    bool IsDH;
    float Depth = get_depth(texcoord, IsDH);
    float DepthL = ld_exact(Depth, IsDH);

    float CoC = calc_CoC(DepthL, DepthCenterL);
    CoC = Depth < 0.56 ? min(10, CoC) : min(25, CoC);
    
    vec4 Color = vec4(blur_dof(texcoord, CoC), 1);

	#ifdef DOF_SHOW_FOCUS
		if(!hideGUI)
			Color.g += float(abs(DepthL - DepthCenterL) < 0.2);
	#endif

    gl_FragData[0] = Color;

    if(all(lessThan(gl_FragCoord.xy, vec2(1)))) {
        gl_FragData[1].r = DepthCenter;
    }
}
