#define OVERWORLD
#define VOXY_TRANSLUCENT

#include "/lib/common.glsl"

// Global Variables //
#if defined OVERWORLD
const vec2 sunRotationData = vec2(cos(sunPathRotation * 0.01745329251994), -sin(sunPathRotation * 0.01745329251994));
float fractTimeAngle = fract(timeAngle - 0.25);
float ang = (fractTimeAngle + (cos(fractTimeAngle * 3.14159265358979) * -0.5 + 0.5 - fractTimeAngle) / 3.0) * 6.28318530717959;
vec3 sunVec = normalize((vxModelView * vec4(vec3(-sin(ang), cos(ang) * sunRotationData) * 2000.0, 1.0)).xyz);
#elif defined END
const vec2 sunRotationData = vec2(cos(sunPathRotation * 0.01745329251994), -sin(sunPathRotation * 0.01745329251994));
vec3 sunVec = normalize((vxModelView * vec4(1.0, sunRotationData * 2000.0, 1.0)).xyz);
#else
vec3 sunVec = vec3(0.0);
#endif

vec3 upVec = normalize(vxModelView[1].xyz);
vec3 eastVec = normalize(vxModelView[0].xyz);

#ifdef OVERWORLD
float eBS = eyeBrightnessSmooth.y / 240.0;
float caveFactor = fmix(clamp((cameraPosition.y - 56.0) / 16.0, float(sign(isEyeInWater)), 1.0), 1.0, sqrt(eBS));
float sunVisibility = clamp((dot( sunVec, upVec) + 0.15) * 3.0, 0.0, 1.0);
float moonVisibility = clamp((dot(-sunVec, upVec) + 0.15) * 3.0, 0.0, 1.0);
vec3 lightVec = sunVec * ((timeAngle < 0.5325 || timeAngle > 0.9675) ? 1.0 : -1.0);
#endif

vec3 tangent = vxModelView[0].xyz;
vec3 binormal = vxModelView[2].xyz;

// Includes //
#include "/lib/util/bayerDithering.glsl"
#include "/lib/util/transformMacros.glsl"
#include "/lib/util/ToNDCVoxy.glsl"
#include "/lib/util/ToWorldVoxy.glsl"
#include "/lib/util/ToShadow.glsl"
#include "/lib/pbr/ggx.glsl"
#include "/lib/lighting/shadowsVoxy.glsl"
#include "/lib/color/lightColor.glsl"
#include "/lib/lighting/lightning.glsl"

#ifdef VC_SHADOWS
#include "/lib/lighting/cloudShadows.glsl"
#endif

#include "/lib/lighting/gbuffersLighting.glsl"
#include "/lib/water/waterFog.glsl"

#ifdef OVERWORLD
#include "/lib/atmosphere/sky.glsl"
#endif

#if WATER_NORMALS > 0
#include "/lib/water/waterNormals.glsl"
#endif

#ifdef WATER_REFLECTIONS
#include "/lib/pbr/raytracerVoxy.glsl"
#include "/lib/pbr/waterReflection.glsl"
#endif

layout(location = 0) out vec4 out0;
layout(location = 1) out vec4 out1;

// Main //
void voxy_emitFragment(VoxyFragmentParameters parameters) {
    vec4 albedoTexture = parameters.sampledColour;
    vec4 voxyColor = parameters.tinting;
    vec4 albedo = albedoTexture * vec4(voxyColor.rgb, 1.0);
    vec2 lightmap = clamp((parameters.lightMap - 0.03125) * 1.06667, vec2(0.0), vec2(0.9333, 1.0));
    float lAlbedo = length(albedoTexture.rgb);

    vec3 screenPos = vec3(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z);
    vec3 viewPos = ToNDC(screenPos);
    vec3 nViewPos = normalize(viewPos);
    vec3 worldPos = ToWorld(viewPos);
    vec3 viewVector = vec3(worldPos.x, worldPos.z, 0.0);

    vec3 normal = vec3(0.0);

    switch (uint(parameters.face) >> 1u) {
        case 0u:
        normal = vxModelView[1].xyz;
        break;
        case 1u:
        normal = vxModelView[2].xyz;
        break;
        case 2u:
        normal = vxModelView[0].xyz;
        break;
    }
    if ((parameters.face & 1) == 0) {
        normal = -normal;
    }

    vec3 newNormal = normal;

	float NoU = clamp(dot(newNormal, upVec), -1.0, 1.0);
    #if defined OVERWORLD
	float NoL = clamp(dot(newNormal, lightVec), 0.0, 1.0);
    #elif defined END
    float NoL = clamp(dot(newNormal, sunVec), 0.0, 1.0);
    #else
    float NoL = 0.0;
    #endif
	float NoE = clamp(dot(newNormal, eastVec), -1.0, 1.0);

    int mat = int(parameters.customId);
	float portal = float(mat == 10031);
	float ice = float(mat == 10000);
	float water = float(mat == 10001);
	float glass = float(mat >= 10201 && mat <= 10216);
	float emission = portal * lAlbedo * lAlbedo * 2.0;
    float smoothness = 0.0;
    float metalness = 0.0;
    float subsurface = 0.0;

	if (water > 0.5) {
		#ifdef VANILLA_WATER
		albedo.rgb *= albedoTexture.rgb;
		albedo.a = WATER_A;
		#else
		//Water Light Absorption & Scattering
		vec4 waterFog = vec4(0.0);

		float oDepth = texture2D(vxDepthTexTrans, screenPos.xy).r;
		vec3 oScreenPos = vec3(gl_FragCoord.xy / vec2(viewWidth, viewHeight), oDepth);
		vec3 oViewPos = ToNDC(oScreenPos);

		vec3 colorMult = vec3(1.0);
		waterFog = getWaterFog(colorMult, viewPos - oViewPos);

		albedo.rgb = waterFog.rgb * 3.0;
		albedo.g *= 1.0 + (0.5 - waterFog.a * 0.35); //Correciton
		albedo.a = min(0.1 + 3.0 * WATER_A * waterFog.a * (0.75 - float(isEyeInWater == 1) * 0.25), 0.8);
		#endif
	} else if (portal > 0.5) {
		vec2 noisePos = worldPos.xy + cameraPosition.xy;
			 noisePos += worldPos.zy + cameraPosition.zy;
			 noisePos.y *= 0.5;
		float portalNoise = texture2D(noisetex, noisePos * 0.1 + 0.01 * vec2(sin(frameTimeCounter * 0.6) + frameTimeCounter * 0.4, frameTimeCounter * 0.5 - cos(frameTimeCounter * 0.7))).r;
			  portalNoise *= portalNoise * portalNoise;
			  portalNoise = clamp(portalNoise, 0.0, 1.0);
		albedo.rgb = pow(vec3(NP_R, NP_G, NP_B), max(vec3(1.0 - portalNoise * 3.0 - pow4(lAlbedo) * 0.25), vec3(0.1))) * 3.0 * portalNoise * (0.8 + pow4(lAlbedo) * 0.6);
	}

	//Volumetric Clouds Blending
	float cloudBlendOpacity = 1.0;

	#ifdef VOLUMETRIC_CLOUDS
	#ifndef DISTANT_HORIZONS
    float farPlane = far + vxRenderDistance * 512.0;
	float cloudDepth = texture2D(gaux2, screenPos.xy).r * (farPlane * 2.0);
	#else
	float cloudDepth = texture2D(gaux2, screenPos.xy).r * dhFarPlane;
	#endif
	cloudBlendOpacity = step(length(viewPos), cloudDepth);

	if (cloudBlendOpacity == 0) {
		discard;
	}
	#endif

	//Water Normals
	float fresnel = clamp(1.0 + dot(normalize(newNormal), nViewPos), 0.0, 1.0);

	#if WATER_NORMALS > 0
	if (water > 0.5) {
		getWaterNormal(newNormal, worldPos, viewVector, length(viewVector), fresnel, normal, binormal, tangent);
	}
	#endif

    float parallaxShadow = 1.0;
    vec3 shadow = vec3(0.0);
    gbuffersLighting(voxyColor, albedo, screenPos, viewPos, worldPos, newNormal, shadow, lightmap, NoU, NoL, NoE, subsurface, emission, smoothness, parallaxShadow);

	//Reflections
	#ifdef WATER_REFLECTIONS
	if (water > 0.5 || glass > 0.5) {
		#if WATER_NORMALS > 0
		float snellWindow = clamp(pow4(length(worldPos.xz) * 0.05), 0.05 + float(isEyeInWater == 0) * 0.95, 1.0);
			  snellWindow = max(snellWindow, float(water < 0.5));
		#else
		float snellWindow = 1.0;
		#endif

		float fresnel = clamp(1.0 + dot(normalize(newNormal), nViewPos), 0.0, 1.0) * snellWindow;
		getReflection(albedo, viewPos, nViewPos, newNormal, fresnel, lightmap.y);
		albedo.a = fmix(albedo.a * snellWindow, 1.0, fresnel);
	}
	#endif

	//Specular Highlights
	#if !defined DISTANT_HORIZONS && !defined NETHER && defined SPECULAR_HIGHLIGHTS
	if (emission < 0.1 && portal < 0.1) {
		float vanillaDiffuse = (0.25 * NoU + 0.75) + (0.667 - abs(NoE)) * (1.0 - abs(NoU)) * 0.15;
			  vanillaDiffuse *= vanillaDiffuse;

		float smoothnessF = 0.6 + length(albedo.rgb) * 0.2 * float(ice > 0.5 || water > 0.5);

		#ifdef OVERWORLD
		vec3 specularHighlight = getSpecularHighlight(newNormal, viewPos, smoothnessF, vec3(0.80), lightColSqrt, shadow * vanillaDiffuse, voxyColor.a);
		#else
		vec3 specularHighlight = getSpecularHighlight(newNormal, viewPos, smoothnessF, vec3(0.40), endLightCol * 0.5, shadow * vanillaDiffuse, voxyColor.a);
		#endif

		albedo.rgb += specularHighlight * 0.5;
	}
	#endif

	albedo.a *= cloudBlendOpacity;

    out0 = albedo;
    out1 = albedo;
}
#undef VOXY_TRANSLUCENT