/********************************************************************************/
/*                                                                              */
/*    Noble Shaders                                                             */
/*    Copyright (C) 2026  Belmu                                                 */
/*                                                                              */
/*    This program is free software: you can redistribute it and/or modify      */
/*    it under the terms of the GNU General Public License as published by      */
/*    the Free Software Foundation, either version 3 of the License, or         */
/*    (at your option) any later version.                                       */
/*                                                                              */
/*    This program is distributed in the hope that it will be useful,           */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/*    GNU General Public License for more details.                              */
/*                                                                              */
/*    You should have received a copy of the GNU General Public License         */
/*    along with this program.  If not, see <https://www.gnu.org/licenses/>.    */
/*                                                                              */
/********************************************************************************/

#define ABOUT 0 // [0 1]

#define RENDER_MODE 0 // [0 1]

// Chunk loader mods support (Distant Horizons, Voxy)
#if defined DISTANT_HORIZONS || defined VOXY
    #define CHUNK_LOADER_MOD_ENABLED
#endif

//////////////////////////////////////////////////////////
/*---------------------- BUFFERS -----------------------*/
//////////////////////////////////////////////////////////

#define MAIN_BUFFER           colortex0

#define GBUFFERS_DATA         colortex1

#define REFLECTIONS_BUFFER    colortex2
#define SHADOWMAP_BUFFER      colortex3
#define DEFERRED_BUFFER       colortex4

#define IRRADIANCE_BUFFER     colortex5
#define ATMOSPHERE_BUFFER     colortex6
#define CLOUDS_BUFFER         colortex7

#define HISTORY_BUFFER        colortex8
#define MOMENTS_BUFFER        colortex10

#define FOG_BUFFER            colortex11

#define AO_BUFFER             colortex12

#define CLOUDMAP_BUFFER       colortex14

#define LUT_BUFFER            colortex6
#define GBUFFERS_BASIC_BUFFER colortex15

//////////////////////////////////////////////////////////
/*----------------- OPTIFINE CONSTANTS -----------------*/
//////////////////////////////////////////////////////////

const float sunPathRotation         = -40.0; // [-90.0 -85.0 -80.0 -75.0 -70.0 -65.0 -60.0 -55.0 -50.0 -45.0 -40.0 -35.0 -30.0 -25.0 -20.0 -15.0 -10.0 -5.0 0.0 5.0 10.0 15.0 20.0 25.0 30.0 35.0 40.0 45.0 50.0 55.0 60.0 65.0 70.0 75.0 80.0 85.0 90.0]
const int   shadowMapResolution     =  3072; // [512 1024 2048 3072 4096 6144 8192 10240]
const float shadowDistance          =  128 ; // [64 128 256 512 1024 2048 4096]
const float shadowDistanceRenderMul =  1.0 ;

//////////////////////////////////////////////////////////
/*---------------------- LIGHTING ----------------------*/
//////////////////////////////////////////////////////////

const float hardcodedRoughness = 0.0; // 0.0 = OFF

#define HANDLIGHT_DISTANCE 20.0

#define DIRECTIONAL_LIGHTMAP 1 // [0 1]

#define SUBSURFACE_SCATTERING 1 // [0 1]

#define HARDCODED_EMISSION       1 // [0 1]
#define HARDCODED_EMISSION_VAL 1.0

#define HARDCODED_SSS        1 // [0 1]
#define HARDCODED_SSS_VAL 0.40

#define BLOCKLIGHT_TEMPERATURE 3000 // [1000 1100 1200 1300 1400 1500 1600 1700 1800 1900 2000 2100 2200 2300 2400 2500 2600 2700 2800 2900 3000 3100 3200 3300 3400 3500 3600 3700 3800 3900 4000 4100 4200 4300 4400 4500 4600 4700 4800 4900 5000 5100 5200 5300 5400 5500 5600 5700 5800 5900 6000 6100 6200 6300 6400 6500 6600 6700 6800 6900 7000 7100 7200 7300 7400 7500 7600 7700 7800 7900 8000 8100 8200 8300 8400 8500 8600 8700 8800 8900 9000 9100 9200 9300 9400 9500 9600 9700 9800 9900 10000 10100 10200 10300 10400 10500 10600 10700 10800 10900 11000 11100 11200 11300 11400 11500 11600 11700 11800 11900 12000 12100 12200 12300 12400 12500 12600 12700 12800 12900 13000 13100 13200 13300 13400 13500 13600 13700 13800 13900 14000 14100 14200 14300 14400 14500 14600 14700 14800 14900 15000]
#define EMISSIVE_INTENSITY      600 // [100 200 300 400 500 600 700 800 900 1000 1100 1200 1300 1400 1500 1600 1700 1800 1900 2000 2100 2200 2300 2400 2500 2600 2700 2800 2900 3000 3100 3200 3300 3400 3500 3600 3700 3800 3900 4000 4100 4200 4300 4400 4500 4600 4700 4800 4900 5000 5100 5200 5300 5400 5500 5600 5700 5800 5900 6000]

#define SUNLIGHT_LEAKING_FIX

#define MAX_ACCUMULATED_FRAMES 20.0

//////////////////////////////////////////////////////////
/*---------------------- SHADOWS -----------------------*/
//////////////////////////////////////////////////////////

#define SHADOWS        1 // [0 1 2 3]
#define SHADOW_SAMPLES 8 // [2 4 6 8 10 12 14 16]

#define SHADOW_DISTORTION    0.85
#define SHADOW_DEPTH_STRETCH 0.25

#define CONTACT_SHADOWS        1 // [0 1]
#define CONTACT_SHADOWS_STEPS  8 // [4 8 16 32]
#define CONTACT_SHADOWS_STRIDE 6

#define NORMAL_SHADOW_PENUMBRA 1.0
#define MIN_SHADOW_PENUMBRA    0.5

// Soft Shadows
#define BLOCKER_SEARCH_SAMPLES   8
#define BLOCKER_SEARCH_RADIUS 30.0
#define LIGHT_SIZE            70.0

//////////////////////////////////////////////////////////
/*------------------ AMBIENT OCCLUSION -----------------*/
//////////////////////////////////////////////////////////

#define AO          1 // [0 1 2 3]
#define MATERIAL_AO 1 // [0 1]
#define AO_FILTER   1 // [0 1]
#define AO_SCALE  100 // [25 50 75 100]

#define SSAO_SAMPLES   12 // [4 8 12 16 20]
#define SSAO_RADIUS   0.7 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define SSAO_STRENGTH 1.3

#define RTAO_SAMPLES 2  // [2 4 6 8 10]
#define RTAO_STRIDE  32 // [1 4 8 16 24 32 48 64]

#define GTAO_HORIZON_STEPS 4
#define GTAO_SLICES        2 // [1 2 3 4 5 6]
#define GTAO_RADIUS      1.0 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

//////////////////////////////////////////////////////////
/*------------- REFLECTIONS | REFRACTIONS --------------*/
//////////////////////////////////////////////////////////

#define SPECULAR 1 // [0 1]

#define REFLECTIONS         1 // [0 1 2]
#define REFLECTIONS_SCALE 100 // [25 50 75 100]

#define REFLECTIONS_STRIDE 48 // [1 4 8 16 24 32 48 64]

#define ROUGH_REFLECTIONS_SAMPLES 1 // [1 2 3 4]

#define REFLECTIONS_SKY_FALLBACK

#define REFRACTIONS        1 // [0 1 2]
#define REFRACTIONS_STRIDE 8

//////////////////////////////////////////////////////////
/*---------------- GLOBAL ILLUMINATION -----------------*/
//////////////////////////////////////////////////////////

#define GI 0 // [0 1]

#define GI_RENDER_DISTANCE 150.0 // Distance in blocks

#define ATROUS_FILTER         1 // [0 1]
#define TEMPORAL_ACCUMULATION 1 // [0 1]

#define VARIANCE_STABILIZATION_THRESHOLD 4.0
#define MIN_FRAMES_LUMINANCE_WEIGHT      4.0

#define MAX_GI_ACCUMULATED_FRAMES 60.0

#define ATROUS_STEP_SIZE      16.0 // [1.0 2.0 4.0 6.0 8.0 10.0 12.0 14.0 16.0 18.0 20.0 21.0 22.0 23.0 24.0 25.0 26.0 27.0 28.0 29.0 30.0 31.0 32.0]
#define NORMAL_WEIGHT_SIGMA   16.0 // [4.0 8.0 16.0 32.0 48.0 64.0 80.0 128.0]
#define DEPTH_WEIGHT_SIGMA     1.0 // [1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0]
#define LUMINANCE_WEIGHT_SIGMA 4.0 // [1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0 21.0 22.0 23.0 24.0 25.0 26.0 27.0 28.0 29.0 30.0 31.0 32.0 33.0 34.0 35.0 36.0 37.0 38.0 39.0 40.0 41.0 42.0 43.0 44.0 45.0 46.0 47.0 48.0 49.0 50.0 51.0 52.0 53.0 54.0 55.0 56.0 57.0 58.0 59.0 60.0 61.0 62.0 63.0 64.0 65.0 66.0 67.0 68.0 69.0 70.0 71.0 72.0 73.0 74.0 75.0 76.0 77.0 78.0 79.0 80.0 81.0 82.0 83.0 84.0 85.0 86.0 87.0 88.0 89.0 90.0 91.0 92.0 93.0 94.0 95.0 96.0 97.0 98.0 99.0 100.0]

#define GI_SAMPLES     1 // [1 2 3 4 5 6 7 8]
#define MAX_GI_BOUNCES 4 // [1 2 3 4 5 6 7 8 9 10 11 12 9999]
#define GI_STRIDE     16 // [1 4 8 16 24 32 48 64]

#define MIN_ROULETTE_BOUNCES -1

#define SKY_CONTRIBUTION 1 // [0 1]
#define RENDER_ENTITIES  1 // [0 1]

//////////////////////////////////////////////////////////
/*-------------------- ATMOSPHERICS --------------------*/
//////////////////////////////////////////////////////////

#define CELESTIAL_SIZE_MULTIPLIER 1 // [1 2 3 4]

// ATMOSPHERE

#define ATMOSPHERE_SCALE              25 // [10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]
#define ATMOSPHERE_SCATTERING_STEPS   16 // [8 12 16 20 24 28 32]
#define ATMOSPHERE_TRANSMITTANCE_STEPS 8 // [8 12 16 20 24 28 32]

// CLOUDS

#define CLOUDS_SCALE 50 // [25 30 40 50 60 70 75 80 90 100]

#define CLOUDS_WIND_SPEED 5 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50]

#define CLOUDS_SHADOWS 			    0 // [0 1]
#define CLOUDS_SHADOWS_RESOLUTION 256 // [128 256 512 1024 2048]

// CLOUD MAP

#define CLOUDMAP         1
#define CLOUDMAP_SCALE 0.4

// CLOUDS LAYER 0

#define CLOUDS_LAYER0_ENABLED 1 // [0 1]

#define CLOUDS_LAYER0_SCALE       45 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define CLOUDS_LAYER0_DETAILSCALE 40 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]

#define CLOUDS_LAYER0_SCATTERING_STEPS 12 // [4 8 12 16 20 24 28 32]
#define CLOUDS_LAYER0_OCTAVES           1 // [1 2 3 4 5 6]

#define CLOUDS_LAYER0_FREQUENCY 0.6 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0 5.1 5.2 5.3 5.4 5.5 5.6 5.7 5.8 5.9 6.0 6.1 6.2 6.3 6.4 6.5 6.6 6.7 6.8 6.9 7.0 7.1 7.2 7.3 7.4 7.5 7.6 7.7 7.8 7.9 8.0]
#define CLOUDS_LAYER0_DENSITY   100 // [0 10 20 30 40 50 60 70 80 90 100 110 120 130 140 150 160 170 180 190 200]

#define CLOUDS_LAYER0_ALTITUDE  2000 // [100 200 300 400 500 600 700 800 900 1000 1100 1200 1300 1400 1500 1600 1700 1800 1900 2000 2500 3000 3500 4000 4500 5000 5500 6000 6500 7000 7500 8000 9500 10000]
#define CLOUDS_LAYER0_THICKNESS 1000 // [100 200 300 400 500 600 700 800 900 1000 1100 1200 1300 1400 1500 1600 1700 1800 1900 2000]
#define CLOUDS_LAYER0_COVERAGE    30 // [5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]
#define CLOUDS_LAYER0_SWIRL       10 // [5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]

// CLOUDS LAYER 1

#define CLOUDS_LAYER1_ENABLED 1 // [0 1]

#define CLOUDS_LAYER1_SCALE      15 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define CLOUDS_LAYER1_DETAILSCALE 1 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]

#define CLOUDS_LAYER1_SCATTERING_STEPS 8 // [4 8 12 16 20 24 28 32]
#define CLOUDS_LAYER1_OCTAVES          1 // [1 2 3 4 5 6]

#define CLOUDS_LAYER1_FREQUENCY 1.2 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0 5.1 5.2 5.3 5.4 5.5 5.6 5.7 5.8 5.9 6.0 6.1 6.2 6.3 6.4 6.5 6.6 6.7 6.8 6.9 7.0 7.1 7.2 7.3 7.4 7.5 7.6 7.7 7.8 7.9 8.0]
#define CLOUDS_LAYER1_DENSITY   100 // [0 10 20 30 40 50 60 70 80 90 100 110 120 130 140 150 160 170 180 190 200]

#define CLOUDS_LAYER1_ALTITUDE 4000 // [100 200 300 400 500 600 700 800 900 1000 1100 1200 1300 1400 1500 1600 1700 1800 1900 2000 2500 3000 3500 4000 4500 5000 5500 6000 6500 7000 7500 8000 9500 10000]
#define CLOUDS_LAYER1_THICKNESS 100 // [100 200 300 400 500 600 700 800 900 1000 1100 1200 1300 1400 1500 1600 1700 1800 1900 2000]
#define CLOUDS_LAYER1_COVERAGE   60 // [5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]
#define CLOUDS_LAYER1_SWIRL      90 // [5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]

// FOG

#define AIR_FOG                     1 // [0 1 2]
#define AIR_FOG_SCATTERING_STEPS    8 // [8 16 24 32 40 48 64]
#define AIR_FOG_TRANSMITTANCE_STEPS 8
#define AIR_FOG_OCTAVES             3

#define FOG_SHAPE_SCALE   8 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define FOG_ALTITUDE   61.0 // [0.0 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0 21.0 22.0 23.0 24.0 25.0 26.0 27.0 28.0 29.0 30.0 31.0 32.0 33.0 34.0 35.0 36.0 37.0 38.0 39.0 40.0 41.0 42.0 43.0 44.0 45.0 46.0 47.0 48.0 49.0 50.0 51.0 52.0 53.0 54.0 55.0 56.0 57.0 58.0 59.0 60.0 61.0 62.0 63.0 64.0 65.0 66.0 67.0 68.0 69.0 70.0 71.0 72.0 73.0 74.0 75.0 76.0 77.0 78.0 79.0 80.0 81.0 82.0 83.0 84.0 85.0 86.0 87.0 88.0 89.0 90.0 91.0 92.0 93.0 94.0 95.0 96.0 97.0 98.0 99.0 100.0]
#define FOG_THICKNESS 100.0 // [5.0 10.0 15.0 20.0 25.0 30.0 35.0 40.0 45.0 50.0 55.0 60.0 65.0 70.0 75.0 80.0 85.0 90.0 95.0 100.0 105.0 110.0 115.0 120.0 125.0 130.0 135.0 140.0 145.0 150.0 155.0 160.0 165.0 170.0 175.0 180.0 185.0 190.0 195.0 200.0]
#define FOG_DENSITY    0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]

#define AERIAL_PERSPECTIVE           1 // [0 1]
#define AERIAL_PERSPECTIVE_DENSITY 1.0 // [0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0 8.5 9.0 9.5 10.0]

#define NETHER_FOG 1 // [0 1]
#define END_FOG 1    // [0 1]

// STARS

#define STARS_SCALE      280 // [50 60 70 80 90 100 110 120 130 140 150 160 170 180 190 200 210 220 230 240 250 260 270 280 290 300 310 320 330 340 350 360 370 380 390 400]
#define STARS_AMOUNT      50 // [0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]
#define STARS_LUMINANCE   50 // [0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]
#define STARS_MIN_TEMP  2500
#define STARS_MAX_TEMP 50000

// WEATHER

#define WEATHER_TILT            1 // [0 1]
#define WEATHER_TILT_ANGLE_X 45.0
#define WEATHER_TILT_ANGLE_Z  0.0

//////////////////////////////////////////////////////////
/*----------------------- TERRAIN ----------------------*/
//////////////////////////////////////////////////////////

#define WHITE_WORLD 0 // [0 1]

#define WAVING_PLANTS 1 // [0 1]

#define WATER_ID                1
#define LAVA_ID                 5
#define FIRE_ID                 6
#define HANGING_LANTERN_ID      8
#define NETHER_PORTAL_ID       10
#define SSS_ID                 11
#define LEAVES_ID              12
#define DOUBLE_PLANTS_LOWER_ID 13
#define DOUBLE_PLANTS_UPPER_ID 14
#define PLANTS_ID              15

#define LIGHTNING_BOLT_ID 63

#define RAIN_PUDDLES       1 // [0 1]
#define RAIN_PUDDLES_SIZE 40 // [0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]

#define RAIN_DIRECTION vec2(0.60, 0.1)

// POM

#define POM           1 // [0 1 2]
#define POM_LAYERS   32 // [32 64 128 256 512]
#define POM_DEPTH   0.4 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define POM_DISTANCE 32 // [16 32 48 64 80 96 112 128 144 160 176 192 208 224 240 256 512]

#define POM_SHADOWING   0 // [0 1]
#define POM_DEPTH_WRITE 0 // [0 1]

// WATER

#define WATER_PARALLAX             1 // [0 1]
#define WATER_PARALLAX_DEPTH     0.1 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define WATER_PARALLAX_LAYERS      4
#define WATER_PARALLAX_DISTANCE 64.0

#define WATER_CAUSTICS               1 // [0 1]
#define WATER_CAUSTICS_STRENGTH    1.0 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define WATER_CAUSTICS_BLUR_RADIUS 0.0

#define WATER_OCTAVES   16 // [2 4 6 8 16 32 48]
#define WAVE_AMPLITUDE 1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]
#define WAVE_STEEPNESS 1.5 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0]
#define WAVE_LENGTH	     5 // [0 0.5 1 1.5 2 2.5 3 3.5 4 4.5 5 5.5 6 6.5 7 7.5 8 8.5 9 9.5 10]

#define WATER_FOG        1 // [0 1]
#define WATER_FOG_STEPS 16 // [4 8 16 32]

#define WATER_ABSORPTION_R 35 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define WATER_ABSORPTION_G 15 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define WATER_ABSORPTION_B 11 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]

#define WATER_SCATTERING_R 5  // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define WATER_SCATTERING_G 10 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define WATER_SCATTERING_B 9  // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]

#define UNDERWATER_DISTORTION         1
#define WATER_DISTORTION_SPEED     0.40
#define WATER_DISTORTION_AMPLITUDE 0.30

//////////////////////////////////////////////////////////
/*-------------------- ANTI-ALIASING -------------------*/
//////////////////////////////////////////////////////////

#define TAA             1 // [0 1]
#define TAA_STRENGTH 0.80 // [0.10 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.20 0.21 0.22 0.23 0.24 0.25 0.26 0.27 0.28 0.29 0.30 0.31 0.32 0.33 0.34 0.35 0.36 0.37 0.38 0.39 0.40 0.41 0.42 0.43 0.44 0.45 0.46 0.47 0.48 0.49 0.50 0.51 0.52 0.53 0.54 0.55 0.56 0.57 0.58 0.59 0.60 0.61 0.62 0.63 0.64 0.65 0.66 0.67 0.68 0.69 0.70 0.71 0.72 0.73 0.74 0.75 0.76 0.77 0.78 0.79 0.80 0.81 0.82 0.83 0.84 0.85 0.86 0.87 0.88 0.89 0.90 0.91 0.92 0.93 0.94 0.95 0.96 0.97 0.98 0.99]

//////////////////////////////////////////////////////////
/*------------------- POST-PROCESSING ------------------*/
//////////////////////////////////////////////////////////

// Depth of Field
#define DOF           0 // [0 1]
#define DOF_RADIUS 10.0 // [0.0 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0 21.0 22.0 23.0 24.0 25.0 26.0 27.0 28.0 29.0 30.0 31.0 32.0 33.0 34.0 35.0 36.0 37.0 38.0 39.0 40.0]
#define DOF_DEPTH     0 // [0 2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36 38 40 42 44 46 48 50 52 54 56 58 60 62 64 128 256 512 1024]
#define DOF_SAMPLES  32 // [4 8 16 32 64]

#define DOF_ABERRATION            1 // [0 1]
#define DOF_ABERRATION_STRENGTH 1.0 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

// Bloom
#define BLOOM             1 // [0 1]
#define BLOOM_STRENGTH 0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]

// Lens Flares
#define LENS_FLARES 0 // [0 1]

#define LENS_FLARES_STRENGTH 1.0 // [0.2 0.4 0.8 1.0 1.2 1.4 1.6 1.8 2.0 2.2 2.4 2.6 2.8 3.0 3.2 3.4 3.6 3.8 4.0 4.2 4.4 4.6 4.8 5.0 5.2 5.4 5.6 5.8 6.0 6.2 6.4 6.6 6.8 7.0 7.2 7.4 7.6 7.8 8.0 8.2 8.4 8.6 8.8 9.0 9.2 9.4 9.6 9.8 10.0]

#define LENS_FLARES_GHOSTS                  6
#define LENS_FLARES_GHOSTS_THIN_FILM        1 // [0 1]
#define LENS_FLARES_GHOSTS_MIN_SPACING   0.30 // [0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define LENS_FLARES_GHOSTS_MAX_SPACING   0.40 // [0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define LENS_FLARES_GHOSTS_SPACING_SIGMA 0.40

#define LENS_FLARES_GHOSTS_ABERRATION             1 // [0 1]
#define LENS_FLARES_GHOSTS_ABERRATION_STRENGTH 20.0

#define LENS_FLARES_HALO             1 // [0 1]
#define LENS_FLARES_HALO_RADIUS    0.6 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define LENS_FLARES_HALO_STRETCH_X 1.0 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define LENS_FLARES_HALO_STRETCH_Y 1.0 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

// Glare
#define GLARE            0 // [0 1]
#define GLARE_STEPS     32
#define GLARE_STRENGTH 1.0 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#define GLARE_THIN_FILM 1 // [0 1]

#define GLARE_BLADES        3 // [1 2 3 4]
#define GLARE_BLADES_SIZE 2.0 // [1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5 7.0 7.5 8.0 8.5 9.0 9.5 10.0]
#define GLARE_BLADES_ANGLE  0 // [0 10 20 30 40 50 60 70 80 90 100 110 120 130 140 150 160 170 180]

// Vignette
#define VIGNETTE             0 // [0 1]
#define VIGNETTE_STRENGTH 0.25 // [0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50]

// Film Grain
#define FILM_GRAIN            0 // [0 1]
#define FILM_GRAIN_STRENGTH 1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

// Sharpen
#define SHARPEN             1 // [0 1]
#define SHARPEN_STRENGTH 1.00 // [0.00 0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00]

// Cel Shading
#define CEL_SHADING 0 // [0 1]
#define CEL_SHADES  8 // [4 8 12 16 20 24 28 32]

// 8-Bits Filter
#define EIGHT_BITS_FILTER 0 // [0 1]

// Palette
#define PALETTE 0 // [0 1 2 3 4 5 6 7 8 9 10]

//////////////////////////////////////////////////////////
/*------------------ CAMERA SETTINGS -------------------*/
//////////////////////////////////////////////////////////

#define EXPOSURE 2 // [0 1 2]

#define EXPOSURE_GROWTH 2.00
#define EXPOSURE_DECAY  0.50

#define EXPOSURE_IGNORE_DARK   0.60
#define EXPOSURE_IGNORE_BRIGHT 0.05

#if EXPOSURE == 2
    #define HISTOGRAM_BINS 80

    // Logarithmic scale
    const float minLogLuminance      = -6.0;
    const float maxLogLuminance      = 16.0;
    const float logLuminanceRange    = maxLogLuminance - minLogLuminance;
    const float rcpLogLuminanceRange = 1.0 / logLuminanceRange;

    const vec2 debugHistogramSize = vec2(370, 208);
#endif

#define FOCAL          24 // [1 2 5 10 14 20 24 28 35 50 70 80 85 100 135 200 300 400 500 600]
#define F_STOPS      16.0 // [1.0 1.2 1.4 2.0 2.8 4.0 5.6 8.0 11.0 16.0 22.0 32.0]
#define ISO           100 // [50 100 200 400 800 1600 3200 6400 12800 25600 51200]
#define SHUTTER_SPEED 125 // [4 5 6 8 10 15 20 30 40 50 60 80 100 125 160 200 250 320 400 500 640 800 1000 1250 1600 2000 2500 3200 4000]

//////////////////////////////////////////////////////////
/*------------------- COLOR GRADING --------------------*/
//////////////////////////////////////////////////////////

#define ACES 1

#define TONEMAP 0 // [-1 0 1 2 3 4 5 6]
#define LUT     0 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20]

#define AGX_LOOK 2

#define PURKINJE 1 // [0 1]

#define WHITE_POINT   6500
#define WHITE_BALANCE 6500 // [5000 5100 5200 5300 5400 5500 5600 5700 5800 5900 6000 6100 6200 6300 6400 6500 6600 6700 6800 6900 7000 7100 7200 7300 7400 7500 7600 7700 7800 7900 8000 8100 8200 8300 8400 8500 8600 8700 8800 8900 9000 9100 9200 9300 9400 9500 9600 9700 9800 9900 10000]

#define VIBRANCE   0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define SATURATION 0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define CONTRAST   0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define GAMMA      0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define GAIN       0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define LIFT       0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]

//////////////////////////////////////////////////////////
/*----------------------- DEBUG ------------------------*/
//////////////////////////////////////////////////////////

#define DEBUG_HISTOGRAM 0 // [0 1]
#define DEBUG_LUT       0 // [0 1]
